/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.dto;

import com.sensedia.interceptor.externaljar.dto.ApiMessage;
import com.sensedia.interceptor.externaljar.dto.Body;
import com.sensedia.interceptor.externaljar.exception.ApiException;
import com.sensedia.interceptor.externaljar.exception.InterceptorException;
import com.sensedia.interceptor.externaljar.util.MultiStringMap;
import java.util.HashMap;

public class Response
extends ApiMessage
implements Cloneable {
    private static final long serialVersionUID = 1L;
    protected Integer status;

    public Integer getStatus() {
        return this.status;
    }

    public Response setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public Response clone() {
        Response clone = new Response();
        clone.headers = MultiStringMap.clone(this.headers);
        clone.status = this.status;
        clone.cookies = new HashMap(this.cookies);
        clone.body = new Body();
        clone.body.setBytes(this.body.getBytes());
        return clone;
    }

    @Override
    public Response cloneWithoutBody() {
        Response clone = new Response();
        clone.headers = MultiStringMap.clone(this.headers);
        clone.status = this.status;
        clone.cookies = new HashMap(this.cookies);
        return clone;
    }

    public static Response error(Integer code, String body) {
        Response r = new Response().setStatus(code);
        r.body.setString(body, "utf-8");
        r.setHeader("Content-Type", "text/plain");
        return r;
    }

    public static Response error(Throwable t) {
        if (t instanceof ApiException) {
            return Response.error(((ApiException)t).getCode(), t.getMessage());
        }
        if (t instanceof InterceptorException) {
            return Response.error(((InterceptorException)t).getCode(), t.getMessage());
        }
        return Response.error(500, "Internal GatewayService error");
    }
}

