/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiStringMap
implements Map<String, String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, List<String>> map = new LinkedHashMap<String, List<String>>();

    public void addValue(String key, String value) {
        this.getOrCreateList(key).add(value);
    }

    public List<String> getAllValues(Object key) {
        return this.map.get(key);
    }

    private List<String> getOrCreateList(Object key) {
        List<String> l = this.map.get(key);
        if (l == null) {
            l = new ArrayList<String>();
            this.map.put(key.toString(), l);
        }
        return l;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public String get(Object key) {
        List<String> l = this.getAllValues(key);
        if (l != null && !this.isEmpty()) {
            return l.get(0);
        }
        return null;
    }

    @Override
    public String put(String key, String value) {
        List<String> l = this.getOrCreateList(key);
        l.clear();
        l.add(value);
        return value;
    }

    @Override
    public String remove(Object key) {
        String s = this.get(key);
        this.map.remove(key);
        return s;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, List<String>> e : this.map.entrySet()) {
            result.addAll((Collection<String>)e.getValue());
        }
        return result;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        for (String k : this.keySet()) {
            m.put(k, this.get(k));
        }
        return m.entrySet();
    }

    public static MultiStringMap clone(MultiStringMap other) {
        MultiStringMap r = new MultiStringMap();
        for (String key : other.keySet()) {
            r.getOrCreateList(key).addAll(other.getAllValues(key));
        }
        return r;
    }

    public String toString() {
        return this.map.toString();
    }
}

