/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.dto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sensedia.interceptor.externaljar.dto.LocationEnum;
import com.sensedia.interceptor.externaljar.dto.LogCall;
import com.sensedia.interceptor.externaljar.dto.ObfuscationItem;
import com.sensedia.interceptor.externaljar.dto.TraceItem;
import com.sensedia.interceptor.externaljar.exception.InterceptorException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Tracer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long t0 = System.currentTimeMillis();
    private List<TraceItem> traceItems = new ArrayList<TraceItem>();
    public List<ObfuscationItem> logObfuscationItems = new ArrayList<ObfuscationItem>();

    public void trace(String message, Object ... params) {
        if (params != null && params.length > 0) {
            this.traceItems.add(new TraceItem(this.t0, String.format(message, params), null));
        } else {
            this.trace(message);
        }
    }

    public void trace(Exception e) {
        if (e instanceof InterceptorException) {
            InterceptorException ex = (InterceptorException)e;
            if (Objects.nonNull(ex.getFlowError().details)) {
                LogCall logCall = new LogCall();
                logCall.log.put("body", ex.getFlowError().details);
                this.traceItems.add(new TraceItem(this.t0, e.getLocalizedMessage(), logCall));
                return;
            }
        }
        this.traceItems.add(new TraceItem(this.t0, e.getLocalizedMessage(), null));
    }

    public void trace(String message) {
        this.traceItems.add(new TraceItem(this.t0, message, null));
    }

    public void trace(Throwable e, String message) {
        this.traceItems.add(new TraceItem(this.t0, e.getLocalizedMessage(), null));
    }

    public void trace(String message, LogCall call) {
        this.trace(message, call, false);
    }

    public void trace(String message, LogCall call, boolean encryptContent) {
        if (!this.logObfuscationItems.isEmpty()) {
            for (ObfuscationItem obfuscationItem : this.logObfuscationItems) {
                if (LocationEnum.BODY.name().equals(obfuscationItem.location)) {
                    this.obfuscationBody(obfuscationItem, call);
                    continue;
                }
                if (!LocationEnum.HEADER.name().equals(obfuscationItem.location)) continue;
                this.obfuscationHeaders(obfuscationItem, call);
            }
        }
        this.traceItems.add(new TraceItem(this.t0, message, call, encryptContent));
    }

    public String getTrace() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(this.traceItems);
        }
        catch (JsonProcessingException e) {
            return e.getMessage();
        }
    }

    public static String applyRegex(ObfuscationItem obfuscationItem, String value) {
        return value.replaceAll(obfuscationItem.regexToReplace, obfuscationItem.replaceChar);
    }

    private void obfuscationBody(ObfuscationItem obfuscationItem, LogCall call) {
        String body;
        if (call.log.containsKey("body") && (body = String.valueOf(call.log.get("body"))).length() > 0) {
            byte[] bytes = body.getBytes();
            String str = new String(bytes, 0, bytes.length, StandardCharsets.UTF_8);
            str = Tracer.applyRegex(obfuscationItem, str);
            call.log.put("body", str);
        }
    }

    private void obfuscationHeaders(ObfuscationItem obfuscationItem, LogCall call) {
        String headerValue;
        if (call.log.containsKey("headers") && (headerValue = String.valueOf(call.log.get("headers"))) != null) {
            obfuscationItem.regexToReplace = obfuscationItem.attr + ": \\w.*";
            obfuscationItem.replaceChar = obfuscationItem.attr + ": " + obfuscationItem.replaceChar;
            call.log.put("headers", Tracer.applyRegex(obfuscationItem, headerValue));
        }
    }

    public List<TraceItem> getTraceItems() {
        return this.traceItems;
    }

    public void setTraceItems(List<TraceItem> traceItems) {
        this.traceItems = traceItems;
    }
}

