/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.rest;

import com.sensedia.interceptor.externaljar.rest.UrlEncodedForm;
import com.sensedia.interceptor.externaljar.util.MultiStringMap;
import java.io.File;
import java.util.ArrayList;
import org.apache.http.Consts;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.message.BasicNameValuePair;

public class RESTRequest {
    private MultiStringMap headers = new MultiStringMap();
    private String method;
    private String uri;
    private Object body;

    public RESTRequest() {
    }

    public RESTRequest(String method, String uri) {
        this.method = method;
        this.uri = uri;
    }

    public RESTRequest(String method, String uri, MultiStringMap headers, Object body) {
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.body = body;
    }

    public MultiStringMap getHeaders() {
        return this.headers;
    }

    public RESTRequest setHeaders(MultiStringMap headers) {
        this.headers = headers;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public RESTRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public RESTRequest setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public Object getBody() {
        return this.body;
    }

    public RESTRequest setBody(Object body) {
        this.body = body;
        return this;
    }

    public RESTRequest setTextBody(String body) {
        this.body = body;
        return this;
    }

    public RESTRequest setHeader(String key, String value) {
        this.headers.addValue(key, value);
        return this;
    }

    public RESTRequest setJsonBody(Object o) {
        try {
            this.body = o;
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RESTRequest setFilePartBody(String partName, File file) {
        this.body = new FormBodyPart(partName, (ContentBody)new FileBody(file));
        return this;
    }

    public RESTRequest setFilePartBody(String partName, String fileName, byte[] fileContents) {
        this.body = new FormBodyPart(partName, (ContentBody)new ByteArrayBody(fileContents, fileName));
        return this;
    }

    public RESTRequest setFormBody(UrlEncodedForm body) {
        ArrayList params = new ArrayList();
        body.getParams().entrySet().forEach(param -> params.add(new BasicNameValuePair((String)param.getKey(), (String)param.getValue())));
        this.body = new UrlEncodedFormEntity(params, Consts.UTF_8);
        return this;
    }
}

