/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sensedia.core.commons.logging.Logger;
import com.sensedia.interceptor.externaljar.rest.RESTException;
import com.sensedia.interceptor.externaljar.rest.RESTRequest;
import com.sensedia.interceptor.externaljar.rest.RESTResponse;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class RESTCaller {
    private static final Logger LOGGER = Logger.getLogger(RESTCaller.class);
    private static final String APPLICATION_JSON_CHARSET = "application/json;charset=utf-8";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String TEXT_PLAIN_CHARSET = "text/plain;charset=utf-8";
    private static final String X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String UTF8 = "utf-8";
    private static final String OCTET_STREAM = "application/octet-stream";
    private String host;
    private Integer port;
    private String protocol;
    private String prefix;
    private String query;
    private Integer timeoutMillis;
    private boolean throwExceptionIfError = false;

    public RESTCaller setDefaultHost(String protocol, String host, int port) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        return this;
    }

    public RESTCaller setDefaultHost(String protocol, String host, int port, String prefix) {
        return this.setDefaultHost(protocol, host, port, prefix, null);
    }

    public RESTCaller setDefaultHost(String protocol, String host, int port, String prefix, String query) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.setPrefix(prefix);
        this.query = query;
        return this;
    }

    public RESTCaller setDefaultHost(String fullHost) {
        try {
            URL u = new URL(fullHost);
            return this.setDefaultHost(u.getProtocol(), u.getHost(), u.getPort(), u.getPath(), u.getQuery());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public RESTCaller setPrefix(String prefix) {
        this.prefix = prefix;
        if (this.prefix.startsWith("/")) {
            this.prefix = this.prefix.substring(1);
        }
        return this;
    }

    public RESTResponse call(String method, String path) {
        return this.call(new RESTRequest(method, path));
    }

    public RESTResponse call(String method, String path, String body) {
        return this.call(new RESTRequest(method, path).setHeader("Content-Type", TEXT_PLAIN).setTextBody(body));
    }

    public RESTResponse call(String method, String path, Object body) {
        return this.call(new RESTRequest(method, path).setHeader("Content-Type", "application/json").setJsonBody(body));
    }

    public RESTResponse call(String method, String path, String partName, File body) {
        return this.call(new RESTRequest(method, path).setFilePartBody(partName, body));
    }

    public RESTResponse call(RESTRequest request) throws RESTException {
        return this.call(request, this.throwExceptionIfError);
    }

    public RESTResponse call(RESTRequest request, boolean exceptionIfError) throws RESTException {
        RequestConfig config = Objects.nonNull(this.timeoutMillis) ? RequestConfig.custom().setSocketTimeout(this.timeoutMillis.intValue()).setConnectTimeout(this.timeoutMillis.intValue()).setConnectionRequestTimeout(this.timeoutMillis.intValue()).build() : RequestConfig.custom().build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(config);
        SSLContextBuilder sslcb = new SSLContextBuilder();
        try {
            sslcb.loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            });
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcb.build(), new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            LOGGER.error("Error configuring ssl", (Throwable)e);
        }
        CloseableHttpClient httpclient = httpClientBuilder.build();
        HttpHost targetHost = new HttpHost(this.host, this.port.intValue(), this.protocol);
        try {
            HttpGet req = null;
            String method = request.getMethod().toUpperCase();
            String uri = request.getUri();
            if (this.prefix != null && this.prefix.trim().length() > 0) {
                uri = this.prefix + uri;
            }
            if (!uri.startsWith("/")) {
                uri = "/" + uri;
            }
            if (this.query != null && !this.query.isEmpty()) {
                uri = uri + "?" + this.query;
            }
            if (method.equals("GET")) {
                req = new HttpGet(uri);
            } else if (method.equals("DELETE")) {
                req = new HttpDelete(uri);
            } else if (method.equals("POST")) {
                req = new HttpPost(uri);
                ((HttpPost)req).setEntity(this.makeEntity(request));
            } else if (method.equals("PUT")) {
                req = new HttpPut(uri);
                ((HttpPut)req).setEntity(this.makeEntity(request));
            } else if (method.equals("PATCH")) {
                req = new HttpPatch(uri);
                ((HttpPatch)req).setEntity(this.makeEntity(request));
            } else if (method.equals("OPTIONS")) {
                req = new HttpOptions(uri);
            }
            for (Map.Entry<String, String> h : request.getHeaders().entrySet()) {
                req.setHeader(h.getKey(), h.getValue());
            }
            CloseableHttpResponse response = httpclient.execute(targetHost, (HttpRequest)req);
            HttpEntity resEntity = response.getEntity();
            RESTResponse result = new RESTResponse();
            result.setStatus(response.getStatusLine().getStatusCode());
            for (Header h : response.getAllHeaders()) {
                result.getHeaders().put(h.getName(), h.getValue());
            }
            if (resEntity != null) {
                result.setResponseText(EntityUtils.toString((HttpEntity)resEntity, (Charset)StandardCharsets.UTF_8));
            }
            if (result.getStatus() >= 400 && exceptionIfError) {
                throw new RESTException(result);
            }
            RESTResponse rESTResponse = result;
            return rESTResponse;
        }
        catch (Exception t) {
            if (t instanceof RESTException) {
                throw (RESTException)t;
            }
            throw new RuntimeException(t);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    private StringEntity payloadDefault(RESTRequest request, Object payload) throws JsonProcessingException {
        String json = new ObjectMapper().writeValueAsString(payload);
        return this.setStringEntity(request, json, APPLICATION_JSON_CHARSET);
    }

    public StringEntity setStringEntity(RESTRequest request, Object payload, String type) {
        StringEntity reqEntity = new StringEntity((String)payload, UTF8);
        reqEntity.setContentType(this.addContentTypeIfMissing(request, type));
        reqEntity.setContentEncoding(UTF8);
        return reqEntity;
    }

    private StringEntity convertPayloadString(RESTRequest request, Object payload) throws JsonProcessingException {
        if (!(payload instanceof String)) {
            payload = new ObjectMapper().writeValueAsString(payload);
        }
        return this.setStringEntity(request, payload, APPLICATION_JSON_CHARSET);
    }

    private HttpEntity makeEntity(RESTRequest request) throws Exception {
        ByteArrayEntity e;
        Object payload = request.getBody();
        if (payload == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("content-type")) continue;
            if (entry.getValue().toLowerCase().contains("application/json")) {
                return this.convertPayloadString(request, payload);
            }
            if (entry.getValue().toLowerCase().contains(TEXT_PLAIN)) {
                return this.setStringEntity(request, payload, TEXT_PLAIN_CHARSET);
            }
            if (!entry.getValue().toLowerCase().contains(OCTET_STREAM)) continue;
            ByteArrayEntity e2 = new ByteArrayEntity((byte[])payload);
            e2.setContentType(this.addContentTypeIfMissing(request, OCTET_STREAM));
            return e2;
        }
        if (payload instanceof String) {
            return this.setStringEntity(request, payload, TEXT_PLAIN_CHARSET);
        }
        if (payload instanceof byte[]) {
            e = new ByteArrayEntity((byte[])payload);
            e.setContentType(this.addContentTypeIfMissing(request, OCTET_STREAM));
            return e;
        }
        if (payload instanceof FormBodyPart) {
            e = new MultipartEntity();
            e.addPart((FormBodyPart)payload);
            return e;
        }
        if (payload instanceof UrlEncodedFormEntity) {
            e = (UrlEncodedFormEntity)payload;
            e.setContentType(this.addContentTypeIfMissing(request, X_WWW_FORM_URLENCODED));
            return e;
        }
        return this.payloadDefault(request, payload);
    }

    private String addContentTypeIfMissing(RESTRequest req, String contentType) {
        Optional<Map.Entry> existingType = req.getHeaders().entrySet().stream().filter(e -> "content-type".equalsIgnoreCase((String)e.getKey())).findFirst();
        if (existingType.isPresent()) {
            return (String)existingType.get().getValue();
        }
        req.getHeaders().put("Content-Type", contentType);
        return contentType;
    }

    public Integer getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public RESTCaller setTimeoutMillis(Integer timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public RESTCaller setTimeoutMillis(Long timeoutMillis) {
        this.timeoutMillis = timeoutMillis.intValue();
        return this;
    }

    public RESTResponse get(String url) {
        return this.call("get", url, null, (Object)null);
    }

    public RESTResponse get(String url, Map<String, Object> headers) {
        return this.call("get", url, headers, null);
    }

    public RESTResponse delete(String url) {
        return this.call("delete", url, null, (Object)null);
    }

    public RESTResponse delete(String url, Map<String, Object> headers) {
        return this.call("delete", url, headers, null);
    }

    public RESTResponse post(String url, Object body) {
        return this.call("post", url, null, body);
    }

    public RESTResponse post(String url, Map<String, Object> headers, Object body) {
        return this.call("post", url, headers, body);
    }

    public RESTResponse put(String url, Object body) {
        return this.call("put", url, null, body);
    }

    public RESTResponse put(String url, Map<String, Object> headers, Object body) {
        return this.call("put", url, headers, body);
    }

    public RESTResponse call(String method, String url, Map<String, ?> headers, Object body) {
        RESTRequest req = new RESTRequest(method, url);
        if (body != null) {
            this.setBody(req, body);
        }
        if (headers != null) {
            for (Map.Entry<String, ?> entry : headers.entrySet()) {
                if (entry.getValue() == null) continue;
                req.getHeaders().put(entry.getKey(), entry.getValue().toString());
            }
        }
        return this.call(req);
    }

    private void setBody(RESTRequest req, Object body) {
        if (body instanceof String) {
            req.setTextBody((String)body);
        } else {
            req.setJsonBody(body);
        }
    }

    public RESTCaller setThrowExceptionIfError(boolean throwExceptionIfError) {
        this.throwExceptionIfError = throwExceptionIfError;
        return this;
    }

    public boolean getThrowExceptionIfError() {
        return this.throwExceptionIfError;
    }
}

