/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.rest;

import com.sensedia.interceptor.externaljar.rest.RESTCaller;
import com.sensedia.interceptor.externaljar.rest.RESTRequest;
import com.sensedia.interceptor.externaljar.rest.RESTResponse;
import com.sensedia.interceptor.externaljar.rest.UrlEncodedForm;
import com.sensedia.interceptor.externaljar.util.MultiStringMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class Http {
    private static final Integer TIMEOUT_DEFAULT = 60;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String APPLICATION_JSON = "application/json";

    public static RESTResponse get(String url) {
        return Http.call("get", url, null, null);
    }

    public static RESTResponse get(String url, MultiStringMap headers) {
        return Http.call("get", url, headers, null);
    }

    public static RESTResponse get(String url, Map<String, Object> headers) {
        return Http.call("get", url, headers, null);
    }

    public static RESTResponse delete(String url) {
        return Http.call("delete", url, null, null);
    }

    public static RESTResponse delete(String url, MultiStringMap headers) {
        return Http.call("delete", url, headers, null);
    }

    public static RESTResponse delete(String url, Map<String, Object> headers) {
        return Http.call("delete", url, headers, null);
    }

    public static RESTResponse post(String url, Object body) {
        return Http.call("post", url, null, body);
    }

    public static RESTResponse post(String url, MultiStringMap headers, Object body) {
        return Http.call("post", url, headers, body);
    }

    public static RESTResponse post(String url, Map<String, Object> headers, Object body) {
        return Http.call("post", url, headers, body);
    }

    public static RESTResponse put(String url, Object body) {
        return Http.call("put", url, null, body);
    }

    public static RESTResponse put(String url, MultiStringMap headers, Object body) {
        return Http.call("put", url, headers, body);
    }

    public static RESTResponse put(String url, Map<String, Object> headers, Object body) {
        return Http.call("put", url, headers, body);
    }

    public static RESTResponse patch(String url, Object body) {
        return Http.call("patch", url, null, body);
    }

    public static RESTResponse patch(String url, MultiStringMap headers, Object body) {
        return Http.call("patch", url, headers, body);
    }

    public static RESTResponse patch(String url, Map<String, Object> headers, Object body) {
        return Http.call("patch", url, headers, body);
    }

    public static RESTResponse options(String url, Object body) {
        return Http.call("options", url, null, body);
    }

    public static RESTResponse options(String url, MultiStringMap headers, Object body) {
        return Http.call("options", url, headers, body);
    }

    public static RESTResponse options(String url, Map<String, Object> headers, Object body) {
        return Http.call("options", url, headers, body);
    }

    public static RESTResponse call(String method, String url, MultiStringMap headers, Object body) {
        return Http.call(method, url, headers, body, TIMEOUT_DEFAULT);
    }

    public static RESTResponse call(String method, String url, MultiStringMap headers, Object body, Integer timeout) {
        RESTRequest req = new RESTRequest(method, "");
        if (body != null) {
            Http.setBody(req, body, headers);
        }
        if (headers != null) {
            req.getHeaders().putAll(headers);
        }
        return new RESTCaller().setTimeoutMillis(TimeUnit.SECONDS.toMillis(timeout.longValue())).setDefaultHost(url).call(req);
    }

    public static RESTResponse call(String method, String url, Map<String, ?> headers, Object body) {
        return Http.call(method, url, headers, body, TIMEOUT_DEFAULT);
    }

    public static RESTResponse call(String method, String url, Map<String, ?> headers, Object body, Integer timeout) {
        MultiStringMap multiStringHeaders = new MultiStringMap();
        if (headers != null) {
            for (String k : headers.keySet()) {
                multiStringHeaders.put(k, (String)headers.get(k));
            }
        }
        return Http.call(method, url, multiStringHeaders, body, timeout);
    }

    private static RESTRequest containsContentType(RESTRequest req, String type) {
        if (!req.getHeaders().containsKeyIgnoreCase(CONTENT_TYPE)) {
            req.getHeaders().addValue(CONTENT_TYPE, type);
        }
        return req;
    }

    private static void setBody(RESTRequest req, Object body) {
        if (body instanceof String) {
            Http.containsContentType(req, TEXT_PLAIN).setTextBody((String)body);
        } else if (body instanceof UrlEncodedForm) {
            Http.containsContentType(req, X_WWW_FORM_URLENCODED).setFormBody((UrlEncodedForm)body);
        } else {
            req.getHeaders().addValue(CONTENT_TYPE, APPLICATION_JSON);
            req.setJsonBody(body);
        }
    }

    private static void setBody(RESTRequest req, Object body, MultiStringMap headers) {
        Optional<Map.Entry> contentTypeJson;
        if (headers != null && (contentTypeJson = headers.entrySet().stream().filter(it -> ((String)it.getKey()).equalsIgnoreCase(CONTENT_TYPE) && ((String)it.getValue()).equalsIgnoreCase(APPLICATION_JSON)).findFirst()).isPresent() && body instanceof String) {
            req.setBody(body);
            return;
        }
        Http.setBody(req, body);
    }
}

