/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.dto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.sensedia.interceptor.externaljar.dto.ApiMessage;
import com.sensedia.interceptor.externaljar.dto.Body;
import com.sensedia.interceptor.externaljar.dto.CachedResponse;
import com.sensedia.interceptor.externaljar.dto.JsonCookie;
import com.sensedia.interceptor.externaljar.exception.ApiException;
import com.sensedia.interceptor.externaljar.exception.InterceptorException;
import com.sensedia.interceptor.externaljar.rest.ErrorResponseFormat;
import com.sensedia.interceptor.externaljar.rest.JSONErrorResponseFormat;
import com.sensedia.interceptor.externaljar.util.MultiStringMap;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.apache.http.entity.ContentType;

public class Response
extends ApiMessage
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Integer status;

    public Integer getStatus() {
        return this.status;
    }

    public Response setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public Response setStatus(String status) {
        if (status == null) {
            this.status = null;
            return this;
        }
        this.status = Integer.valueOf(status);
        return this;
    }

    @Override
    public Response clone() {
        Response clone = new Response();
        clone.headers = MultiStringMap.clone(this.headers);
        clone.status = this.status;
        clone.cookies = new HashMap(this.cookies);
        clone.body = new Body();
        clone.body.setBytes(this.body.getBytes());
        return clone;
    }

    @Override
    public Response cloneWithoutBody() {
        Response clone = new Response();
        clone.headers = MultiStringMap.clone(this.headers);
        clone.status = this.status;
        clone.cookies = new HashMap(this.cookies);
        return clone;
    }

    public static Response error(InterceptorException exception, String body) {
        ErrorResponseFormat errorResponseFormat = exception.getErrorResponseFormat();
        if (ContentType.APPLICATION_JSON == errorResponseFormat.getContentType()) {
            JSONErrorResponseFormat jsonFormat = (JSONErrorResponseFormat)errorResponseFormat;
            try {
                String jsonBody = jsonFormat.buildJSONErrorResponse(body);
                Response r = new Response().setStatus(exception.getCode());
                r.body.setString(jsonBody, StandardCharsets.UTF_8);
                r.setHeader("Content-Type", errorResponseFormat.getContentTypeString());
                return r;
            }
            catch (JsonProcessingException e) {
                return Response.error(exception.getCode(), body);
            }
        }
        return Response.error(exception.getCode(), body);
    }

    public static Response error(Integer statusCode, String body) {
        Response r = new Response().setStatus(statusCode);
        r.body.setString(body, StandardCharsets.UTF_8);
        r.setHeader("Content-Type", ContentType.TEXT_PLAIN.getMimeType());
        return r;
    }

    public static Response error(InterceptorException interceptorException) {
        String body = Objects.nonNull(interceptorException.getFlowError().details) ? interceptorException.getFlowError().details : interceptorException.getMessage();
        Response r = Response.error(interceptorException, body);
        r.headers.putAll(interceptorException.getHeaders());
        return r;
    }

    public static Response error(Throwable t) {
        if (t instanceof InterceptorException) {
            InterceptorException ex = (InterceptorException)t;
            return Response.error(ex);
        }
        if (t instanceof ApiException) {
            return Response.error(((ApiException)t).getCode(), t.getMessage());
        }
        return Response.error(500, "Internal GatewayService error");
    }

    public CachedResponse toCachedResponse() {
        CachedResponse cachedResponse = new CachedResponse();
        cachedResponse.setBody(this.body);
        ArrayList<JsonCookie> cookies = new ArrayList<JsonCookie>(this.cookies.values());
        cachedResponse.setCookies(cookies);
        cachedResponse.setHeaders(this.headers);
        cachedResponse.setStatus(this.status);
        return cachedResponse;
    }
}

